/*
 * Decompiled with CFR 0.152.
 */
package dguv.common.querschnitt.cache;

import dguv.common.querschnitt.cache.CacheElement;
import dguv.common.querschnitt.cache.CacheSource;
import dguv.common.querschnitt.cache.CacheSourceException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CommonCache<K, V> {
    private CacheSource<K, V> mCacheSource;
    private ConcurrentHashMap<K, CacheElement<V>> mCache = new ConcurrentHashMap();
    private long mExpirationDurationSeconds;
    private static final Logger LOG = Logger.getLogger(CommonCache.class);
    private static final long EXPIRATION_DURATION_SECONDS_DEFAULT = 86400L;

    public CommonCache(CacheSource<K, V> aCacheSource, long aExpirationDurationSeconds) {
        if (aCacheSource == null) {
            throw new IllegalArgumentException("Keine gueltige CacheSource uebergeben!");
        }
        this.mCacheSource = aCacheSource;
        this.mExpirationDurationSeconds = aExpirationDurationSeconds;
    }

    public CommonCache(CacheSource<K, V> aCacheSource) {
        this(aCacheSource, 86400L);
    }

    public V getValue(K aKey) {
        boolean lRefreshNeeded = false;
        CacheElement<V> lElement = null;
        if (this.mCache.containsKey(aKey)) {
            lElement = this.mCache.get(aKey);
            Duration lDurationFromLastRefresh = Duration.between(lElement.getRefreshTimestamp(), LocalDateTime.now());
            if (lDurationFromLastRefresh.getSeconds() >= this.mExpirationDurationSeconds) {
                lRefreshNeeded = true;
            }
        } else {
            lRefreshNeeded = true;
        }
        if (lRefreshNeeded) {
            try {
                V lRefreshedValue = this.mCacheSource.loadFromSource(aKey);
                if (lElement == null) {
                    lElement = new CacheElement();
                    this.mCache.put(aKey, lElement);
                }
                lElement.setValue(lRefreshedValue);
            }
            catch (CacheSourceException e) {
                LOG.warn((Object)("Fehler beim Refresh des Caches fuer den Schluessel " + aKey.toString() + ": " + e.getMessage()));
            }
        }
        return lElement != null ? (V)lElement.getValue() : null;
    }

    public int clear() {
        int lAnzahlElemente = this.mCache.size();
        this.mCache.clear();
        return lAnzahlElemente;
    }
}

