/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder;

import dguv.daleuv.common.DaleCommonConstants;
import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.common.document.DaleSegment;
import dguv.daleuv.common.document.impl.DaleDocumentImpl;
import dguv.unidav.common.document.UniDavDocumentException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelBuilderUtils {
    private static ThreadLocal<DateFormat> DATE_DDMMYYYY = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd.MM.yyyy"));
    private static Pattern PROPERTY_PATTERN = Pattern.compile("[a-z]{3}[0-9]+");

    public static String formatDateDDMMYYYY(Date aDate) {
        return aDate == null ? "" : DATE_DDMMYYYY.get().format(aDate);
    }

    public static String formatPlzOrt(String aLand, String aPlz, String aOrt) {
        StringBuilder lBuilder = new StringBuilder();
        lBuilder.append(DaleDocumentImpl.plzKorrektur(aPlz, aLand)).append(' ').append(aOrt.trim());
        return lBuilder.toString();
    }

    @Deprecated
    public static String formatLandPlzOrt(String aLand, String aPlz, String aOrt) {
        StringBuilder lBuilder = new StringBuilder();
        if (!(ModelBuilderUtils.istLeer(aLand) || "DE".equalsIgnoreCase(aLand) || "unb".equalsIgnoreCase(aLand))) {
            lBuilder.append(aLand.trim()).append('-');
        }
        if (!ModelBuilderUtils.istLeer(aPlz)) {
            lBuilder.append(aPlz.trim()).append(' ');
        }
        if (!ModelBuilderUtils.istLeer(aOrt)) {
            lBuilder.append(aOrt.trim());
        }
        return lBuilder.toString().trim();
    }

    @Deprecated
    public static String formatAnschrift(String aName, String aStrasse, String aLand, String aPlz, String aOrt) {
        return ModelBuilderUtils.formatAnschrift(aName, aStrasse, aLand, aPlz, aOrt, ", ");
    }

    @Deprecated
    public static String formatAnschrift(String aName, String aStrasse, String aLand, String aPlz, String aOrt, String aTrennzeichen) {
        String lLandPlzOrt = ModelBuilderUtils.formatLandPlzOrt(aLand, aPlz, aOrt);
        return ModelBuilderUtils.konkateniere(aTrennzeichen, false, aName, aStrasse, lLandPlzOrt);
    }

    @Deprecated
    public static String formatAnschriftZweizeilig(String aName, String aStrasse, String aLand, String aPlz, String aOrt, String aTrennzeichen) {
        return aName + "\n" + ModelBuilderUtils.konkateniere(aTrennzeichen, false, aStrasse, ModelBuilderUtils.formatLandPlzOrt(aLand, aPlz, aOrt));
    }

    public static String formatAdresse(String aName, String aStrasse, String aLand, String aPlz, String aOrt) {
        return ModelBuilderUtils.formatAdresse(aName, aStrasse, aLand, aPlz, aOrt, ", ");
    }

    public static String formatAdresse(String aName, String aStrasse, String aLand, String aPlz, String aOrt, String aTrennzeichen) {
        String lPlzOrt = ModelBuilderUtils.formatPlzOrt(aLand, aPlz, aOrt);
        String lLandBezeichnung = DaleCommonConstants.LAND.get(aLand);
        if (ModelBuilderUtils.istLeer(lLandBezeichnung) || lLandBezeichnung.equals(DaleCommonConstants.LAND.get("DE")) || lLandBezeichnung.equals(DaleCommonConstants.LAND.get("unb"))) {
            return ModelBuilderUtils.konkateniere(aTrennzeichen, false, aName, aStrasse, lPlzOrt);
        }
        return ModelBuilderUtils.konkateniere(aTrennzeichen, false, aName, aStrasse, lPlzOrt, lLandBezeichnung.toUpperCase());
    }

    public static String formatAdresseZweizeilig(String aName, String aStrasse, String aLand, String aPlz, String aOrt, String aTrennzeichen) {
        String lPlzOrt = ModelBuilderUtils.formatPlzOrt(aLand, aPlz, aOrt);
        String lLandBezeichnung = DaleCommonConstants.LAND.get(aLand);
        if (ModelBuilderUtils.istLeer(lLandBezeichnung) || lLandBezeichnung.equals(DaleCommonConstants.LAND.get("DE")) || lLandBezeichnung.equals(DaleCommonConstants.LAND.get("unb"))) {
            return aName + "\n" + ModelBuilderUtils.konkateniere(aTrennzeichen, false, aStrasse, lPlzOrt);
        }
        return aName + "\n" + ModelBuilderUtils.konkateniere(aTrennzeichen, false, aStrasse, lPlzOrt, lLandBezeichnung.toUpperCase());
    }

    public static String konkateniere(String aSeparator, boolean aDruckeSeparatorBeiLeer, String ... aNamen) {
        StringBuilder lResult = new StringBuilder();
        for (int i = 0; i < aNamen.length; ++i) {
            boolean lLeer = ModelBuilderUtils.istLeer(aNamen[i]);
            if (i > 0 && (!lLeer && lResult.length() > 0 || aDruckeSeparatorBeiLeer)) {
                lResult.append(aSeparator);
            }
            if (lLeer) continue;
            lResult.append(aNamen[i].trim());
        }
        return lResult.toString();
    }

    public static String mitPraefix(String aString, String aPraefix) {
        if (ModelBuilderUtils.istLeer(aString)) {
            return "";
        }
        return (aPraefix == null ? "" : aPraefix) + aString;
    }

    public static boolean istLeer(String aString) {
        return aString == null || "".equals(aString.trim());
    }

    public static void uebertrageWerte(Object aZiel, DaleDocument aQuelle) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aZiel, (String s) -> aQuelle.getString(s.substring(0, 3), s.substring(0, 3) + "_" + s.substring(3)), (String s) -> true);
    }

    public static void uebertrageWerte(Object aZiel, DaleSegment aQuelle, String aSegmentName) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aZiel, (String s) -> aQuelle.getString(s.substring(0, 3) + "_" + s.substring(3)), (String s) -> s.equals(aSegmentName));
    }

    private static void uebertrageWerte(Object aZiel, SegmentFunction<String, String> aWertErmittler, Predicate<String> aSegmentAnwendbar) throws UniDavDocumentException {
        try {
            PropertyDescriptor[] lPdArray;
            for (PropertyDescriptor lPd : lPdArray = Introspector.getBeanInfo(aZiel.getClass(), Object.class).getPropertyDescriptors()) {
                Matcher lMatcher = PROPERTY_PATTERN.matcher(lPd.getName());
                if (!String.class.equals(lPd.getPropertyType()) || lPd.getWriteMethod() == null || !lMatcher.find() || lMatcher.start() > 0 || !aSegmentAnwendbar.test(lMatcher.group().substring(0, 3))) continue;
                lPd.getWriteMethod().invoke(aZiel, aWertErmittler.apply(lMatcher.group()));
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e.toString(), e);
        }
    }

    @FunctionalInterface
    private static interface SegmentFunction<T, R> {
        public R apply(T var1) throws UniDavDocumentException;
    }
}

