/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.common.enums.GvContextProperty;
import dguv.daleuv.report.ReportModelBuilder;
import dguv.daleuv.report.model.dale.AnschreibenReportModel;
import dguv.daleuv.report.model.dale.DaleBaseReportModel;
import dguv.daleuv.report.model.dale.MasterFusszeileModel;
import dguv.daleuv.report.model.dale.MasterKopfzeileModel;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.AdressBuilder;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.dao.Nachrichtentyp;
import dguv.unidav.common.dao.PostAdresse;
import dguv.unidav.common.document.UniDavDocumentException;

public abstract class DaleAbstractReportModelBuilder
implements ReportModelBuilder {
    private String mFormId;
    private String mBerichtsArt;

    protected DaleAbstractReportModelBuilder(Nachrichtentyp aNachrichtentyp) {
        String[] lTeile = aNachrichtentyp.getTyp().trim().split("_");
        this.mBerichtsArt = lTeile.length > 1 ? lTeile[lTeile.length - 1] : "UV";
        this.mFormId = lTeile[0] + "_" + aNachrichtentyp.getFormKennung().trim();
    }

    @Override
    public String getFormId() {
        return this.mFormId;
    }

    protected String getBerichtsArt() {
        return this.mBerichtsArt;
    }

    protected void fuelleKopfUndFussZeile(GVContext aGvContext, DaleBaseReportModel aModel) throws UniDavDocumentException {
        DaleDocument lDaleDocument = (DaleDocument)aGvContext.getUniDavDocument();
        MasterKopfzeileModel lKopf = aModel.getMasterKopfzeileModel();
        lKopf.setKontext_FileName(aGvContext.getNachrichtenkennung() + ".pdf");
        lKopf.setKontext_NKennung(aGvContext.getNachrichtenkennung());
        lKopf.setKontext_Unidaveingang(ModelBuilderUtils.formatDateDDMMYYYY(aGvContext.getEingangsdatum()));
        lKopf.setKontext_GeburtsdatumVers(lDaleDocument.getString("vin", "vin_9"));
        lKopf.setKontext_NameVornameVers(ModelBuilderUtils.konkateniere(", ", false, lDaleDocument.getString("vin", "vin_1"), lDaleDocument.getString("vin", "vin_2")));
        lKopf.setKontext_Unfalltag(lDaleDocument.getString("uvt", "uvt_4"));
        MasterFusszeileModel lFuss = aModel.getMasterFusszeileModel();
        lFuss.setKontext_FileName(aGvContext.getNachrichtenkennung() + ".pdf");
        lFuss.setKontext_Unidaveingang(ModelBuilderUtils.formatDateDDMMYYYY(aGvContext.getEingangsdatum()));
        lFuss.setXML_Unh2_NachrichtentypVersion(lDaleDocument.getString("unh", "unh_2"));
        lFuss.setDecrementiereSeitenzahlen(this.isAnschreibenBenoetigt(aGvContext));
        aModel.setTestGv(aGvContext.isTestGV());
    }

    protected void fuelleAnschreibenFallsBenoetigt(GVContext aGVContext, String aTitel, AnschreibenReportModel aAnschreibenReportModel) throws UniDavDocumentException {
        if (this.isAnschreibenBenoetigt(aGVContext)) {
            DaleDocument lDaleDocument = (DaleDocument)aGVContext.getUniDavDocument();
            aAnschreibenReportModel.setKontext_BerichtsArt(this.getBerichtsArt());
            aAnschreibenReportModel.setKontext_Titel(aTitel);
            aAnschreibenReportModel.setAbsender(this.getAbsender(lDaleDocument));
            aAnschreibenReportModel.setAdressat(this.getAdressat(lDaleDocument));
        }
    }

    private String getAbsender(DaleDocument aDaleDocument) throws UniDavDocumentException {
        if ("GKV".equalsIgnoreCase(this.getBerichtsArt())) {
            return "DGUV, Alte Heerstra\u00dfe 111, 53757 Sankt Augustin";
        }
        return new AdressBuilder(aDaleDocument, "abs", 1).ausgebenZweizeilig(", ");
    }

    private String getAdressat(DaleDocument aDaleDocument) throws UniDavDocumentException {
        if ("GKV".equalsIgnoreCase(this.getBerichtsArt())) {
            StringBuilder lBuilder = new StringBuilder();
            PostAdresse lAdresseGKV = aDaleDocument.getVersandAdresseGKV();
            lBuilder.append(lAdresseGKV.getAdressatErsteZeile()).append("\n").append(lAdresseGKV.getAdressatZweiteZeile()).append("\n");
            if (!lAdresseGKV.istPostfachAdresse()) {
                lBuilder.append(lAdresseGKV.getStrasseHausnummer()).append("\n").append(lAdresseGKV.getPostleitzahlHausanschrift()).append(" ").append(lAdresseGKV.getOrtHausanschrift());
            } else {
                if (!lAdresseGKV.hatGrosskundenPLZ()) {
                    lBuilder.append("Postfach " + lAdresseGKV.getPostfach());
                }
                lBuilder.append("\n").append(lAdresseGKV.getPostleitzahlPostfachanschrift()).append(" ").append(lAdresseGKV.getOrtPostfachanschrift());
            }
            return lBuilder.toString().trim();
        }
        if ("WBA".equalsIgnoreCase(this.getBerichtsArt())) {
            return this.getWbaAdressBuilder(aDaleDocument).ausgebenMehrzeilig();
        }
        if ("KON".equalsIgnoreCase(this.getBerichtsArt())) {
            return new AdressBuilder(aDaleDocument, "kon", 2).ausgebenMehrzeilig();
        }
        return "Adresse unbekannt";
    }

    protected AdressBuilder getWbaAdressBuilder(DaleDocument aDaleDocument) throws UniDavDocumentException {
        return AdressBuilder.NULL;
    }

    private boolean isAnschreibenBenoetigt(GVContext aGvContext) {
        return Boolean.TRUE.equals(aGvContext.getProperty(GvContextProperty.ANSCHREIBEN_NOETIG.name()));
    }
}

