/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.report.ReportModel;
import dguv.daleuv.report.model.dale.DABEReportModel;
import dguv.daleuv.report.model.dale.DABEReportModelSubreport;
import dguv.daleuv.report.model.dale.DisModel;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.daleuv.report.modelbuilder.dale.DaleAbstractReportModelBuilder;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.AdressBuilder;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.PartModelBuilder;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.dao.Nachrichtentyp;
import dguv.unidav.common.document.UniDavDocumentException;

public class DABE_ReportModelBuilder
extends DaleAbstractReportModelBuilder {
    private static final String KONTEXT_TITEL = "Durchgangsarztbericht";

    public DABE_ReportModelBuilder(Nachrichtentyp aNachrichtentyp) {
        super(aNachrichtentyp);
    }

    @Override
    public ReportModel buildModel(GVContext aGVContext) {
        DABEReportModel lModel = new DABEReportModel();
        lModel.setKontext_BerichtsArt(this.getBerichtsArt());
        try {
            this.fuelleAnschreibenFallsBenoetigt(aGVContext, KONTEXT_TITEL, lModel.getAnschreibenModel());
            this.fuelleKopfUndFussZeile(aGVContext, lModel);
            lModel.getKopfbereichModel().setKontext_BerichtsArt(this.getBerichtsArt());
            PartModelBuilder.fuelleDabeMasterKopfBereich(aGVContext, lModel.getKopfbereichModel(), KONTEXT_TITEL);
            DaleDocument lDaleDocument = (DaleDocument)aGVContext.getUniDavDocument();
            this.fuelleHauptteil(lDaleDocument, lModel.getDabeReportModelSubreport());
            PartModelBuilder.fuelleAbsBereich(lDaleDocument, lModel.getAbsModel());
            PartModelBuilder.fuelleNotBereich(lDaleDocument, lModel.getNotModel());
            PartModelBuilder.fuelleRechnungsInfo(lDaleDocument, lModel.getSriModel());
        }
        catch (UniDavDocumentException e) {
            throw new IllegalStateException(e.toString(), e);
        }
        return lModel;
    }

    private void fuelleHauptteil(DaleDocument aDocument, DABEReportModelSubreport aModel) throws UniDavDocumentException {
        aModel.setKontext_BerichtsArt(this.getBerichtsArt());
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        aModel.setBeh11910_LandPlzOrtWeiterbehandelndePraxis(ModelBuilderUtils.formatLandPlzOrt(aDocument.getString("beh", "beh_11"), aDocument.getString("beh", "beh_9"), aDocument.getString("beh", "beh_10")));
        aModel.setKon645_LandPlzOrtKonsiliararzt(ModelBuilderUtils.formatLandPlzOrt(aDocument.getString("kon", "kon_6"), aDocument.getString("kon", "kon_4"), aDocument.getString("kon", "kon_5")));
        PartModelBuilder.fuelleDisSegmente(aDocument, m -> aModel.addToDiagnosen((DisModel)m));
    }

    @Override
    protected AdressBuilder getWbaAdressBuilder(DaleDocument aDaleDocument) throws UniDavDocumentException {
        return new AdressBuilder(aDaleDocument, "beh", 7);
    }
}

