/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.common.document.DaleSegment;
import dguv.daleuv.report.ReportModel;
import dguv.daleuv.report.model.dale.DisModel;
import dguv.daleuv.report.model.dale.KOEBReportModel;
import dguv.daleuv.report.model.dale.KOEBReportModelSubreport;
import dguv.daleuv.report.model.dale.KopfBefundModel;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.daleuv.report.modelbuilder.dale.DaleAbstractReportModelBuilder;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.PartModelBuilder;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.dao.Nachrichtentyp;
import dguv.unidav.common.document.UniDavDocumentException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class KOEB_ReportModelBuilder
extends DaleAbstractReportModelBuilder {
    public KOEB_ReportModelBuilder(Nachrichtentyp aNachrichtentyp) {
        super(aNachrichtentyp);
    }

    @Override
    public ReportModel buildModel(GVContext aGVContext) {
        KOEBReportModel lModel = new KOEBReportModel();
        try {
            this.fuelleKopfUndFussZeile(aGVContext, lModel);
            DaleDocument lDaleDocument = (DaleDocument)aGVContext.getUniDavDocument();
            PartModelBuilder.fuelleEbMasterKopfBereich(lDaleDocument, lModel.getKopfbereichModel(), aGVContext.getNachrichtenkennung());
            this.fuelleHauptteil(lDaleDocument, lModel.getKoebReportModelSubreport());
            PartModelBuilder.fuelleAbsBereich(lDaleDocument, lModel.getAbsModel());
            PartModelBuilder.fuelleNotBereich(lDaleDocument, lModel.getNotModel());
        }
        catch (UniDavDocumentException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        return lModel;
    }

    private void fuelleHauptteil(DaleDocument aDocument, KOEBReportModelSubreport aModel) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        this.prozessiereBekSegmente(aDocument, aModel);
        this.prozessiereAtmSegmente(aDocument, aModel);
        this.prozessiereSonSegmente(aDocument, aModel);
        this.prozessiereBemSegmente(aDocument, aModel);
        PartModelBuilder.fuelleDisSegmente(aDocument, m -> aModel.addToDiagnosen((DisModel)m));
    }

    private KopfBefundModel getBefundModel(String aUntersuchZeitpunkt, KOEBReportModelSubreport aModel) {
        switch (aUntersuchZeitpunkt) {
            case "1": {
                return aModel.getBefundUnfallort();
            }
            case "2": {
                return aModel.getBefundAufnahme();
            }
            case "3": {
                return aModel.getBefundVerlauf24();
            }
        }
        return aModel.getBefundUnfallort();
    }

    private void prozessiereBekSegmente(DaleDocument aDocument, KOEBReportModelSubreport aModel) throws UniDavDocumentException {
        Enumeration<DaleSegment> lBekSegments = aDocument.getSegments("bek");
        while (lBekSegments.hasMoreElements()) {
            DaleSegment lBekSegment = lBekSegments.nextElement();
            KopfBefundModel lBefundModel = this.getBefundModel(lBekSegment.getString("bek_1"), aModel);
            ModelBuilderUtils.uebertrageWerte((Object)lBefundModel, lBekSegment, "bek");
        }
    }

    private void prozessiereAtmSegmente(DaleDocument aDocument, KOEBReportModelSubreport aModel) throws UniDavDocumentException {
        Enumeration<DaleSegment> lAtmSegments = aDocument.getSegments("atm");
        while (lAtmSegments.hasMoreElements()) {
            DaleSegment lAtmSegment = lAtmSegments.nextElement();
            KopfBefundModel lBefundModel = this.getBefundModel(lAtmSegment.getString("atm_1"), aModel);
            ModelBuilderUtils.uebertrageWerte((Object)lBefundModel, lAtmSegment, "atm");
        }
    }

    private void prozessiereSonSegmente(DaleDocument aDocument, KOEBReportModelSubreport aModel) throws UniDavDocumentException {
        HashMap<String, TreeSet<String>> lSon2Map = new HashMap<String, TreeSet<String>>();
        StringBuilder lSon3Builder = new StringBuilder();
        Enumeration<DaleSegment> lSonSegments = aDocument.getSegments("son");
        while (lSonSegments.hasMoreElements()) {
            DaleSegment lSonSegment = lSonSegments.nextElement();
            String lSon1 = lSonSegment.getString("son_1");
            if (!ModelBuilderUtils.istLeer(lSonSegment.getString("son_3"))) {
                lSon3Builder.append("Untersuchung ").append(lSon1).append(": ");
                if (!ModelBuilderUtils.istLeer(lSonSegment.getString("son_2"))) {
                    lSon3Builder.append(lSonSegment.getString("son_2")).append(", ");
                }
                lSon3Builder.append(lSonSegment.getString("son_3")).append("\n");
            }
            TreeSet<String> lSon2Set = (TreeSet<String>)lSon2Map.get(lSon1);
            if (ModelBuilderUtils.istLeer(lSonSegment.getString("son_2"))) continue;
            if (lSon2Set == null) {
                lSon2Set = new TreeSet<String>();
                lSon2Map.put(lSon1, lSon2Set);
            }
            lSon2Set.add(lSonSegment.getString("son_2"));
        }
        aModel.setSon3_Ergaenzungen(lSon3Builder.toString());
        for (Map.Entry lEntry : lSon2Map.entrySet()) {
            KopfBefundModel lBefundModel = this.getBefundModel((String)lEntry.getKey(), aModel);
            lBefundModel.setSon2_Sonstiges(ModelBuilderUtils.konkateniere(",", false, ((SortedSet)lEntry.getValue()).toArray(new String[((SortedSet)lEntry.getValue()).size()])));
        }
    }

    private void prozessiereBemSegmente(DaleDocument aDocument, KOEBReportModelSubreport aModel) throws UniDavDocumentException {
        Enumeration<DaleSegment> lBemSegments = aDocument.getSegments("bem");
        StringBuilder lBem2Builder = new StringBuilder();
        while (lBemSegments.hasMoreElements()) {
            DaleSegment lBemSegment = lBemSegments.nextElement();
            String lBem_1 = lBemSegment.getString("bem_1");
            KopfBefundModel lBefundModel = this.getBefundModel(lBem_1, aModel);
            lBefundModel.setBem1_BesMassn(lBem_1);
            if (ModelBuilderUtils.istLeer(lBemSegment.getString("bem_2"))) continue;
            lBem2Builder.append("Untersuchung ").append(lBem_1).append(": ").append(lBemSegment.getString("bem_2")).append("\n");
        }
        aModel.setBem2_BesMassn(lBem2Builder.toString());
    }
}

