/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.common.document.DaleSegment;
import dguv.daleuv.report.ReportModel;
import dguv.daleuv.report.model.dale.QUITTReportModel;
import dguv.daleuv.report.model.dale.QuittGvFehlerModel;
import dguv.daleuv.report.model.dale.QuittGvModel;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.daleuv.report.modelbuilder.dale.DaleAbstractReportModelBuilder;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.dao.Nachrichtentyp;
import dguv.unidav.common.document.UniDavDocumentException;
import java.util.Enumeration;

public class QUITT_ReportModelBuilder
extends DaleAbstractReportModelBuilder {
    public QUITT_ReportModelBuilder(Nachrichtentyp aNachrichtentyp) {
        super(aNachrichtentyp);
    }

    @Override
    public ReportModel buildModel(GVContext aGVContext) {
        QUITTReportModel lModel = new QUITTReportModel();
        DaleDocument lDocument = (DaleDocument)aGVContext.getUniDavDocument();
        try {
            Enumeration<DaleSegment> lArztSegments;
            Enumeration<DaleSegment> lUnidavSegments = lDocument.getSegments("unidav");
            if (lUnidavSegments.hasMoreElements()) {
                DaleSegment lUnidavSegment = lUnidavSegments.nextElement();
                lModel.setUnidavName(lUnidavSegment.getString("unidav_name"));
                lModel.setUnidavOrt(lUnidavSegment.getString("unidav_ort"));
            }
            if ((lArztSegments = lDocument.getSegments("arzt")).hasMoreElements()) {
                DaleSegment lArztSegment = lArztSegments.nextElement();
                lModel.setArztIk(lArztSegment.getString("arzt_ik"));
                lModel.setArztMail(lArztSegment.getString("arzt_mail"));
            }
            Enumeration<DaleSegment> lDateiSegments = lDocument.getSegments("datei");
            while (lDateiSegments.hasMoreElements()) {
                QuittGvModel lGvModel = this.erzeugeQuittGvModel(lDateiSegments.nextElement());
                lModel.addToQuittGvModel(lGvModel);
            }
        }
        catch (UniDavDocumentException e) {
            throw new IllegalStateException(e.toString(), e);
        }
        return lModel;
    }

    private QuittGvModel erzeugeQuittGvModel(DaleSegment aSegment) throws UniDavDocumentException {
        QuittGvModel lModel = new QuittGvModel();
        lModel.setDateiName(aSegment.getString("dat_nam"));
        lModel.setNachrichtenTyp(aSegment.getString("dat_typ"));
        String lStatus = aSegment.getString("dat_status");
        lModel.setStatusFarbe(this.getStatusFarbe(lStatus));
        lModel.setStatusText(this.getStatusText(lStatus));
        lModel.setSendezeit(aSegment.getString("dat_dat") + " " + aSegment.getString("dat_time"));
        lModel.setEmpf(aSegment.getString("dat_empf_name") + " (" + aSegment.getString("dat_empf") + ")");
        Enumeration<DaleSegment> lFehlerSegments = aSegment.getSegments("dat_fehler");
        while (lFehlerSegments.hasMoreElements()) {
            DaleSegment lFehlerSegment = lFehlerSegments.nextElement();
            QuittGvFehlerModel lFehlerModel = this.erzeugeQuittGvFehlerModel(lFehlerSegment);
            lModel.addToQuittGvFehlerModel(lFehlerModel);
        }
        return lModel;
    }

    private QuittGvFehlerModel erzeugeQuittGvFehlerModel(DaleSegment lFehlerSegment) throws UniDavDocumentException {
        QuittGvFehlerModel lFehlerModel = new QuittGvFehlerModel();
        StringBuilder lFehlerText = new StringBuilder();
        String lFehlerFeldFach = lFehlerSegment.getString("fehler_feld_fach");
        if (!ModelBuilderUtils.istLeer(lFehlerFeldFach)) {
            lFehlerText.append("Feld \"").append(lFehlerFeldFach).append("\": ");
        }
        lFehlerText.append(lFehlerSegment.getString("fehler_text"));
        String lFehlerCode = lFehlerSegment.getString("fehler_code");
        String lFehlerFeldTech = lFehlerSegment.getString("fehler_feld_tech");
        if (!ModelBuilderUtils.istLeer(lFehlerCode) || !ModelBuilderUtils.istLeer(lFehlerFeldTech)) {
            lFehlerText.append(" (").append(ModelBuilderUtils.konkateniere(", ", false, lFehlerFeldTech, lFehlerCode)).append(")");
        }
        lFehlerModel.setFehlerText(lFehlerText.toString());
        return lFehlerModel;
    }

    private String getStatusFarbe(String aStatus) {
        switch (aStatus) {
            case "0": 
            case "3": {
                return "green";
            }
            case "5": {
                return "yellow";
            }
        }
        return "red";
    }

    private String getStatusText(String aStatus) {
        switch (aStatus) {
            case "0": {
                return "Der Bericht wurde erfolgreich \u00fcbermittelt.";
            }
            case "3": {
                return "In diesem Bericht sind folgende Warnungen aufgetreten:";
            }
            case "5": {
                return "Dieser Bericht wurde bereits \u00fcbermittelt und wird deswegen nicht erneut weitergeleitet.";
            }
        }
        return "In diesem Bericht sind folgende Fehler aufgetreten:";
    }
}

