/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl.parts;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.common.document.DaleSegment;
import dguv.daleuv.report.model.dale.AbsModel;
import dguv.daleuv.report.model.dale.DabeMasterKopfBereichModel;
import dguv.daleuv.report.model.dale.DisModel;
import dguv.daleuv.report.model.dale.EbMasterKopfBereichModel;
import dguv.daleuv.report.model.dale.KtoModel;
import dguv.daleuv.report.model.dale.NotModel;
import dguv.daleuv.report.model.dale.RechKopfBereichModel;
import dguv.daleuv.report.model.dale.RelModel;
import dguv.daleuv.report.model.dale.SriModel;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.document.UniDavDocumentException;
import java.util.Enumeration;
import java.util.function.Consumer;

public class PartModelBuilder {
    public static void fuelleDabeMasterKopfBereich(GVContext aGvContext, DabeMasterKopfBereichModel aModel, String aTitel) throws UniDavDocumentException {
        DaleDocument lDaleDocument = (DaleDocument)aGvContext.getUniDavDocument();
        ModelBuilderUtils.uebertrageWerte(aModel, lDaleDocument);
        aModel.setKontext_NKennung(aGvContext.getNachrichtenkennung());
        aModel.setKontext_Titel(aTitel);
        aModel.setUfb234_LandPLZOrtUnfallbetrieb(ModelBuilderUtils.formatLandPlzOrt(lDaleDocument.getString("ufb", "ufb_2"), lDaleDocument.getString("ufb", "ufb_3"), lDaleDocument.getString("ufb", "ufb_4")));
        aModel.setVin856_LandPLZOrtVers(ModelBuilderUtils.formatLandPlzOrt(lDaleDocument.getString("vin", "vin_8"), lDaleDocument.getString("vin", "vin_5"), lDaleDocument.getString("vin", "vin_6")));
    }

    public static void fuelleEbMasterKopfBereich(DaleDocument aDocument, EbMasterKopfBereichModel aModel, String aNKennung) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        aModel.setVin12_NameVornameVers(ModelBuilderUtils.konkateniere(", ", false, aDocument.getString("vin", "vin_1"), aDocument.getString("vin", "vin_2")));
        aModel.setKontext_NKennung(aNKennung);
    }

    public static void fuelleRechnungKopf(DaleDocument aDocument, RechKopfBereichModel aModel, String aNKennung) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        aModel.setKontext_NKennung(aNKennung);
        aModel.setUfb234_LandPLZOrtUnfallbetrieb(ModelBuilderUtils.formatLandPlzOrt(aDocument.getString("ufb", "ufb_2"), aDocument.getString("ufb", "ufb_3"), aDocument.getString("ufb", "ufb_4")));
        aModel.setVinKont12_NameVornameVers(ModelBuilderUtils.konkateniere(", ", false, aDocument.getString("vin", "vin_1"), aDocument.getString("vin", "vin_2")));
        aModel.setVin856_LandPLZOrtVers(ModelBuilderUtils.formatLandPlzOrt(aDocument.getString("vin", "vin_8"), aDocument.getString("vin", "vin_5"), aDocument.getString("vin", "vin_6")));
        PartModelBuilder.fuelleAbsBereich(aDocument, aModel.getAbsModel());
        PartModelBuilder.fuelleDisSegmente(aDocument, m -> aModel.addToDiagnosen((DisModel)m));
    }

    public static void fuelleAbsBereich(DaleDocument aDocument, AbsModel aModel) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        aModel.setAbs534_LandPLZOrtsname(ModelBuilderUtils.formatLandPlzOrt(aDocument.getString("abs", "abs_5"), aDocument.getString("abs", "abs_3"), aDocument.getString("abs", "abs_4")));
    }

    public static void fuelleNotBereich(DaleDocument aDocument, NotModel aModel) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
    }

    public static void fuelleDisSegmente(DaleDocument aDocument, Consumer<DisModel> aConsumer) throws UniDavDocumentException {
        Enumeration<DaleSegment> lDisSegments = aDocument.getSegments("dis");
        while (lDisSegments.hasMoreElements()) {
            DaleSegment lDisSegment = lDisSegments.nextElement();
            DisModel lDisModel = new DisModel();
            ModelBuilderUtils.uebertrageWerte((Object)lDisModel, lDisSegment, "dis");
            aConsumer.accept(lDisModel);
        }
    }

    public static void fuelleRechnungsInfo(DaleDocument aDocument, SriModel aModel) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        aModel.setTextRechnungstyp(ModelBuilderUtils.mitPraefix(aModel.getSri2_Rechnungstyp(), "R "));
        switch (aModel.getSri1_ArtDerHeilbehandlung()) {
            case "1": {
                aModel.setTextArtDerHeilbehandlung("allgemeine");
                break;
            }
            case "2": {
                aModel.setTextArtDerHeilbehandlung("besondere");
                break;
            }
            case "3": {
                aModel.setTextArtDerHeilbehandlung("keine");
                break;
            }
            default: {
                aModel.setTextArtDerHeilbehandlung(aModel.getSri1_ArtDerHeilbehandlung());
            }
        }
        PartModelBuilder.fuelleKtoSegmente(aDocument, m -> aModel.addToKonten((KtoModel)m));
        PartModelBuilder.fuelleRelSegmente(aDocument, m -> aModel.addToLeistungspositionen((RelModel)m));
    }

    public static void fuelleKtoSegmente(DaleDocument aDocument, Consumer<KtoModel> aConsumer) throws UniDavDocumentException {
        Enumeration<DaleSegment> lKtoSegments = aDocument.getSegments("kto");
        while (lKtoSegments.hasMoreElements()) {
            DaleSegment lKtoSegment = lKtoSegments.nextElement();
            KtoModel lKtoModel = new KtoModel();
            ModelBuilderUtils.uebertrageWerte((Object)lKtoModel, lKtoSegment, "kto");
            aConsumer.accept(lKtoModel);
        }
    }

    public static void fuelleRelSegmente(DaleDocument aDocument, Consumer<RelModel> aConsumer) throws UniDavDocumentException {
        Enumeration<DaleSegment> lRelSegments = aDocument.getSegments("rel");
        while (lRelSegments.hasMoreElements()) {
            DaleSegment lRelSegment = lRelSegments.nextElement();
            RelModel lRelModel = new RelModel();
            ModelBuilderUtils.uebertrageWerte((Object)lRelModel, lRelSegment, "rel");
            aConsumer.accept(lRelModel);
        }
    }
}

