/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.exec;

import dguv.unidav.common.exec.ProgExec;
import dguv.unidav.common.exec.impl.DefaultProgExecImpl;
import dguv.unidav.common.exec.impl.ProgExecUnixImpl;
import dguv.unidav.common.exec.impl.ProgExecWindowsImpl;
import org.apache.log4j.Logger;

public class ProgExecFactory {
    private static final Logger log = Logger.getLogger(ProgExecFactory.class);
    public static final long DEFAULT_PROG_TIMEOUT_MS = 30000L;
    public static final long TIMEDIMENSION_MILLISECONDS = 1L;
    public static final long TIMEDIMENSION_SECONDS = 1000L;
    public static final long TIMEDIMENSION_MINUTES = 60000L;
    public static final long TIMEDIMENSION_HOURS = 360000L;

    public static ProgExec createProgExec() {
        return ProgExecFactory.createProgExec(30000L);
    }

    public static ProgExec createProgExec(String timeAsString, long timeDimensionConst) {
        long timeoutVal;
        try {
            timeoutVal = Long.parseLong(timeAsString);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("ProgExecFactory.createProgExec(): Der \u00fcbergebene Wert [" + timeAsString + "] ist keine Zahl - verwende Standard Timeout [" + 30000L + "] millisekunden."));
            return ProgExecFactory.createProgExec();
        }
        log.debug((Object)("ProgExecFactory.createProgExec(): ProgExec Objekt erfolgreich mit Timeout Wert=[" + (timeoutVal *= timeDimensionConst) + "] millisekunden (umgerechnet!) erzeugt"));
        return ProgExecFactory.createProgExec(timeoutVal);
    }

    public static ProgExec createProgExec(long timeoutInMS) {
        String lOsName = System.getProperty("os.name");
        log.debug((Object)("ProgExecFactory: ProgTimeout=[" + timeoutInMS + "]"));
        if (lOsName.startsWith("Windows")) {
            log.debug((Object)("ProgExecFactory: Windows als OS erkannt. System-Property [os.name] liefert Wert [" + lOsName + "]"));
            return new ProgExecWindowsImpl(timeoutInMS);
        }
        if (lOsName.startsWith("Linux")) {
            log.debug((Object)("ProgExecFactory: Windows als OS erkannt. System-Property [os.name] liefert Wert [" + lOsName + "]"));
            return new ProgExecUnixImpl(timeoutInMS);
        }
        log.debug((Object)("ProgExecFactory: KEIN OS erkannt. System-Property [os.name] liefert Wert [" + lOsName + "] - Verwende default"));
        return new DefaultProgExecImpl(timeoutInMS);
    }
}

