/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.exec.impl;

import dguv.unidav.common.exception.TechnicalException;
import dguv.unidav.common.exec.ProgExec;
import dguv.unidav.common.exec.ProgExecTimeoutException;
import dguv.unidav.common.exec.impl.ExecStreamReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DefaultProgExecImpl
implements ProgExec {
    private static final Logger log = Logger.getLogger(DefaultProgExecImpl.class);
    private long progTimeout;

    public DefaultProgExecImpl(long aProgTimeout) {
        this.progTimeout = aProgTimeout;
    }

    @Override
    public long getProgTimeout() {
        return this.progTimeout;
    }

    @Override
    public void setProgTimeout(long aProgTimeout) {
        this.progTimeout = aProgTimeout;
    }

    @Override
    public int execProg(String aProg) throws ProgExecTimeoutException, TechnicalException {
        return this.execProg(aProg, null, null);
    }

    @Override
    public int execProg(String aProg, StringBuffer aStdout, StringBuffer aStderr) throws ProgExecTimeoutException, TechnicalException {
        try {
            String[] lProg = this.convertProgToCmdArray(aProg);
            Runtime lRuntime = Runtime.getRuntime();
            Process lProcess = lRuntime.exec(lProg);
            ExecStreamReader lStdReader = new ExecStreamReader(lProcess.getInputStream(), aStdout);
            ExecStreamReader lErrReader = new ExecStreamReader(lProcess.getErrorStream(), aStderr);
            lStdReader.start();
            lErrReader.start();
            int lExitValue = -1;
            long lTimeout = 0L;
            while (lExitValue == -1) {
                try {
                    lExitValue = lProcess.exitValue();
                    break;
                }
                catch (IllegalThreadStateException e) {
                    if (lTimeout > this.progTimeout) {
                        lProcess.destroy();
                        throw new ProgExecTimeoutException("Timeout Programmaufruf; Timeout=[" + this.progTimeout / 1000L + "] Sek; Prog=[" + aProg + "]");
                    }
                    if (this.progTimeout - lTimeout <= 10000L && lTimeout % 1000L == 0L) {
                        log.warn((Object)("Timeout Programmaufruf droht; Restzeit=[" + (this.progTimeout - lTimeout) / 1000L + "] Sek; Prog=[" + aProg + "]"));
                    }
                    Thread.sleep(500L);
                    lTimeout += 500L;
                }
            }
            return lExitValue;
        }
        catch (IOException e) {
            throw new TechnicalException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new TechnicalException(e.getMessage(), e);
        }
    }

    protected String[] convertProgToCmdArray(String aProg) {
        StringTokenizer lTokenizer = new StringTokenizer(aProg, " ");
        String[] lCmdArray = new String[lTokenizer.countTokens()];
        for (int i = 0; i < lCmdArray.length; ++i) {
            lCmdArray[i] = lTokenizer.nextToken();
        }
        return lCmdArray;
    }
}

