/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public static byte[] getFileDataFrom(byte[] aZipData, String aEntryName) throws IOException {
        return ZipHelper.getEntryDataFrom(aEntryName, new ByteArrayInputStream(aZipData));
    }

    public static byte[] getEntryDataFrom(String aEntryName, File aZipFile) throws IOException {
        return ZipHelper.getEntryDataFrom(aEntryName, new FileInputStream(aZipFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getEntryDataFrom(String aEntryName, InputStream aInputStream) throws IOException {
        ZipInputStream lZipInput = null;
        ByteArrayOutputStream lWriter = new ByteArrayOutputStream();
        try {
            lZipInput = new ZipInputStream(aInputStream);
            boolean lEntryFound = false;
            ZipEntry lEntry = lZipInput.getNextEntry();
            while (lEntry != null) {
                if (lEntry.getName().equalsIgnoreCase(aEntryName)) {
                    lEntryFound = true;
                    break;
                }
                lEntry = lZipInput.getNextEntry();
            }
            if (lEntryFound) {
                int lNbytes;
                byte[] lBuffer = new byte[4096];
                while ((lNbytes = lZipInput.read(lBuffer)) != -1) {
                    lWriter.write(lBuffer, 0, lNbytes);
                }
                byte[] byArray = lWriter.toByteArray();
                return byArray;
            }
        }
        finally {
            lWriter.close();
            aInputStream.close();
            if (lZipInput != null) {
                lZipInput.close();
            }
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listEntries(byte[] aZipData, boolean aListDirectories) throws IOException {
        ByteArrayInputStream lIn = null;
        try {
            String[] lEntries;
            lIn = new ByteArrayInputStream(aZipData);
            String[] stringArray = lEntries = ZipHelper.listEntries(lIn, aListDirectories);
            return stringArray;
        }
        finally {
            if (lIn != null) {
                lIn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listEntries(byte[] aZipData) throws IOException {
        ByteArrayInputStream lIn = null;
        try {
            String[] lEntries;
            lIn = new ByteArrayInputStream(aZipData);
            String[] stringArray = lEntries = ZipHelper.listEntries(lIn);
            return stringArray;
        }
        finally {
            if (lIn != null) {
                lIn.close();
            }
        }
    }

    public static String[] listEntries(File aZipFile) throws IOException {
        FileInputStream lIn = new FileInputStream(aZipFile);
        String[] lEntries = ZipHelper.listEntries(lIn);
        lIn.close();
        return lEntries;
    }

    public static String[] listEntries(InputStream aInputStream) throws IOException {
        ZipInputStream lZipInput = new ZipInputStream(aInputStream);
        ArrayList<String> lList = new ArrayList<String>();
        ZipEntry lEntry = lZipInput.getNextEntry();
        while (lEntry != null) {
            lList.add(lEntry.getName());
            lEntry = lZipInput.getNextEntry();
        }
        lZipInput.close();
        return lList.toArray(new String[lList.size()]);
    }

    public static String[] listEntries(InputStream aInputStream, boolean aListDirectories) throws IOException {
        ZipInputStream lZipInput = new ZipInputStream(aInputStream);
        ArrayList<String> lList = new ArrayList<String>();
        ZipEntry lEntry = lZipInput.getNextEntry();
        while (lEntry != null) {
            if (lEntry.isDirectory() && !aListDirectories) {
                lEntry = lZipInput.getNextEntry();
                continue;
            }
            lList.add(lEntry.getName());
            lEntry = lZipInput.getNextEntry();
        }
        lZipInput.close();
        return lList.toArray(new String[lList.size()]);
    }

    public static byte[] addToZip(byte[] aRawZipData, String aEntryName, byte[] aEntryData) throws IOException {
        ByteArrayInputStream lIn = new ByteArrayInputStream(aRawZipData);
        byte[] lData = ZipHelper.addToZip(lIn, aEntryName, aEntryData);
        lIn.close();
        return lData;
    }

    public static byte[] addToZip(InputStream aRawZipData, String aEntryName, byte[] aEntryData) throws IOException {
        ByteArrayOutputStream lWriter = new ByteArrayOutputStream();
        ZipOutputStream lZipOutput = new ZipOutputStream(lWriter);
        ZipInputStream lZipInput = new ZipInputStream(aRawZipData);
        ZipEntry lEntry = lZipInput.getNextEntry();
        while (lEntry != null) {
            lZipOutput.putNextEntry(new ZipEntry(lEntry.getName()));
            byte[] lBuffer = new byte[65535];
            while (true) {
                int lNbytes;
                if ((lNbytes = lZipInput.read(lBuffer)) == -1) break;
                lZipOutput.write(lBuffer, 0, lNbytes);
            }
            lZipOutput.closeEntry();
            lEntry = lZipInput.getNextEntry();
        }
        lZipOutput.putNextEntry(new ZipEntry(aEntryName));
        lZipOutput.write(aEntryData, 0, aEntryData.length);
        lZipOutput.closeEntry();
        lZipOutput.flush();
        lZipOutput.close();
        lWriter.close();
        lZipInput.close();
        return lWriter.toByteArray();
    }

    public static File extractFile(String aZipFile, String aDestDir, String aEntryName) throws IOException {
        int lNbytes;
        InputStream lIn = ZipHelper.extractFile(aZipFile, aEntryName);
        if (lIn == null) {
            return null;
        }
        String lFileName = aDestDir + "/" + aEntryName;
        FileOutputStream lOut = new FileOutputStream(lFileName);
        byte[] lBuffer = new byte[65535];
        while ((lNbytes = lIn.read(lBuffer)) != -1) {
            lOut.write(lBuffer, 0, lNbytes);
        }
        lOut.close();
        lIn.close();
        File lFile = new File(lFileName);
        if (lFile.exists()) {
            return lFile;
        }
        return null;
    }

    public static InputStream extractFile(String aZipFile, String aFileName) throws IOException {
        return ZipHelper.extractFile(new FileInputStream(aZipFile), aFileName);
    }

    public static void extractFiles(String aZipFile, String aDestPath) throws IOException {
        FileInputStream lFileIn = new FileInputStream(aZipFile);
        ZipHelper.extractFiles(lFileIn, aDestPath);
        lFileIn.close();
    }

    public static InputStream extractFile(InputStream aReader, String aFileName) throws IOException {
        ZipInputStream lZipInput = new ZipInputStream(aReader);
        ZipEntry lEntry = lZipInput.getNextEntry();
        while (lEntry != null && !lEntry.getName().equalsIgnoreCase(aFileName)) {
            lEntry = lZipInput.getNextEntry();
        }
        if (lEntry != null) {
            return lZipInput;
        }
        lZipInput.close();
        return null;
    }

    private static void extractFiles(InputStream aReader, String aDestPath) throws IOException {
        ZipInputStream lZipInput = new ZipInputStream(aReader);
        ZipEntry lEntry = lZipInput.getNextEntry();
        while (lEntry != null) {
            FileOutputStream lFileOut = new FileOutputStream(aDestPath + "/" + lEntry.getName());
            byte[] lBuffer = new byte[65535];
            while (true) {
                int lNbytes;
                if ((lNbytes = lZipInput.read(lBuffer)) == -1) break;
                lFileOut.write(lBuffer, 0, lNbytes);
            }
            lFileOut.close();
            lEntry = lZipInput.getNextEntry();
        }
        lZipInput.close();
        aReader.close();
    }
}

