/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.VirtualizableElementList;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizationObjectInputStream;
import net.sf.jasperreports.renderers.Renderable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRVirtualPrintPage
implements JRPrintPage,
Serializable {
    protected static final Log log = LogFactory.getLog(JRVirtualPrintPage.class);
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_VIRTUAL_PAGE_ELEMENT_SIZE = "net.sf.jasperreports.virtual.page.element.size";
    private VirtualizableElementList elements;

    public JRVirtualPrintPage(JasperPrint printObject, JRVirtualizer virtualizer, JRVirtualizationContext virtualizationContext) {
        this(printObject, virtualizationContext);
    }

    public JRVirtualPrintPage(JasperPrint printObject, JRVirtualizationContext virtualizationContext) {
        this.elements = new VirtualizableElementList(virtualizationContext, this);
        if (log.isDebugEnabled()) {
            log.debug("created list " + this.elements + " for page " + this);
        }
    }

    @Override
    public List<JRPrintElement> getElements() {
        return this.elements;
    }

    @Override
    public void setElements(List<JRPrintElement> elements) {
        this.elements.set(elements);
    }

    @Override
    public void addElement(JRPrintElement element) {
        this.elements.add(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (object instanceof VirtualizableElementList) {
            this.elements = (VirtualizableElementList)object;
        } else {
            String oldUid = (String)object;
            if (log.isDebugEnabled()) {
                log.debug("Original page uid " + oldUid);
            }
            JRVirtualizationContext virtualizationContext = (JRVirtualizationContext)in.readObject();
            int length = in.readInt();
            byte[] buffer = new byte[length];
            in.readFully(buffer);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, buffer.length);
            try (VirtualizationObjectInputStream elementsStream = new VirtualizationObjectInputStream(inputStream, virtualizationContext);){
                List elementsList = (List)elementsStream.readObject();
                this.elements = new VirtualizableElementList(virtualizationContext, this);
                this.elements.addAll(elementsList);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.elements);
    }

    public void dispose() {
        this.elements.dispose();
    }

    public JRVirtualizationContext getVirtualizationContext() {
        return this.elements.getVirtualizationContext();
    }

    public static class JRIdHolderTemplateElement
    extends JRTemplateElement {
        private static final long serialVersionUID = 10200L;

        public JRIdHolderTemplateElement(String id) {
            super(id);
        }

        @Override
        public int getHashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIdentical(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    public static class JRIdHolderRenderer
    implements Renderable {
        private static final long serialVersionUID = 10200L;
        protected final String id;

        public JRIdHolderRenderer(Renderable renderer) {
            this.id = renderer.getId();
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

