/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MultiErrorHandler
implements ErrorHandler {
    private ErrorHandler[] errHandlerArr = new ErrorHandler[4];
    private int numErrHandler = 0;

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        for (int i = 0; i < this.numErrHandler; ++i) {
            ErrorHandler errorHandler = this.errHandlerArr[i];
            errorHandler.error(sAXParseException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        for (int i = 0; i < this.numErrHandler; ++i) {
            ErrorHandler errorHandler = this.errHandlerArr[i];
            errorHandler.fatalError(sAXParseException);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        for (int i = 0; i < this.numErrHandler; ++i) {
            ErrorHandler errorHandler = this.errHandlerArr[i];
            errorHandler.warning(sAXParseException);
        }
    }

    public void addErrorHandler(ErrorHandler errorHandler) {
        int n = this.errHandlerArr.length;
        if (n <= this.numErrHandler) {
            ErrorHandler[] errorHandlerArray = new ErrorHandler[n * 2];
            System.arraycopy(this.errHandlerArr, 0, errorHandlerArray, 0, n);
            this.errHandlerArr = errorHandlerArray;
        }
        this.errHandlerArr[this.numErrHandler++] = errorHandler;
    }

    public ErrorHandler[] getErrorHandlers() {
        return this.errHandlerArr;
    }

    public int getNumErrorHandlers() {
        return this.numErrHandler;
    }

    public final boolean removeErrorHandler(ErrorHandler errorHandler) {
        for (int i = 0; i < this.numErrHandler; ++i) {
            ErrorHandler errorHandler2 = this.errHandlerArr[i];
            if (errorHandler2 != errorHandler) continue;
            this.errHandlerArr[i] = this.errHandlerArr[this.numErrHandler - 1];
            --this.numErrHandler;
            return true;
        }
        return false;
    }
}

