/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.pipeline.controller.Error;
import oracle.xml.pipeline.controller.InParam;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.OutParam;
import oracle.xml.pipeline.controller.Output;
import oracle.xml.pipeline.controller.PipeDocElement;
import oracle.xml.pipeline.controller.PipeError;
import oracle.xml.pipeline.controller.PipelineConstants;
import oracle.xml.pipeline.controller.PipelineDoc;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.PipelineProcessor;
import oracle.xml.pipeline.controller.ProcessDoneEvent;
import oracle.xml.pipeline.controller.ProcessListener;
import oracle.xml.pipeline.controller.SAXHandler;
import oracle.xml.pipeline.controller.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Process
implements Runnable,
PipelineConstants,
ProcessListener,
ErrorHandler {
    private String id;
    private String type;
    private Boolean ignoreErrors;
    private PipelineDoc pipeDoc;
    private PipelineProcessor processor;
    private boolean multiThreaded = false;
    private PipeError pipeError;
    private DOMParser domParser;
    private Hashtable inputs;
    private Hashtable outputs;
    private Hashtable errors;
    private Hashtable inParams;
    private Hashtable outParams;
    private Vector listenerList;
    private Vector prevProcessList;
    private short processStatus = 0;
    private boolean compatible = true;

    final void init(XMLElement xMLElement, PipelineProcessor pipelineProcessor, PipeError pipeError) throws MalformedURLException, PipelineException {
        PipeDocElement pipeDocElement;
        int n;
        this.processor = pipelineProcessor;
        if (this.processor.getThreadCount() > 1) {
            this.multiThreaded = true;
        }
        this.pipeDoc = this.processor.getPipeDoc();
        this.id = xMLElement.getAttribute("id");
        this.type = xMLElement.getAttribute("type");
        this.ignoreErrors = new Boolean(xMLElement.getAttribute("ignore-errors"));
        this.pipeError = pipeError;
        NodeList nodeList = xMLElement.getChildrenByTagName("input");
        int n2 = nodeList.getLength();
        if (n2 > 0) {
            this.inputs = new Hashtable(n2);
        }
        for (n = 0; n < n2; ++n) {
            pipeDocElement = new Input((XMLElement)nodeList.item(n), this.processor);
            this.addInput((Input)pipeDocElement);
        }
        nodeList = xMLElement.getChildrenByTagName("output");
        n2 = nodeList.getLength();
        if (n2 > 0) {
            this.outputs = new Hashtable(n2);
        }
        for (n = 0; n < n2; ++n) {
            pipeDocElement = new Output((XMLElement)nodeList.item(n), this.processor);
            this.addOutput((Output)pipeDocElement);
        }
        nodeList = xMLElement.getChildrenByTagName("error");
        n2 = nodeList.getLength();
        if (n2 > 0) {
            this.errors = new Hashtable(n2);
        }
        for (n = 0; n < n2; ++n) {
            pipeDocElement = new Error((XMLElement)nodeList.item(n), this.processor);
            this.addError((Error)pipeDocElement);
        }
        nodeList = xMLElement.getChildrenByTagName("param");
        n2 = nodeList.getLength();
        if (n2 > 0) {
            this.inParams = new Hashtable(n2);
        }
        for (n = 0; n < n2; ++n) {
            pipeDocElement = new InParam((XMLElement)nodeList.item(n), this.processor);
            this.addInParam((InParam)pipeDocElement);
        }
        nodeList = xMLElement.getChildrenByTagName("outparam");
        n2 = nodeList.getLength();
        if (n2 > 0) {
            this.outParams = new Hashtable(n2);
        }
        for (n = 0; n < n2; ++n) {
            pipeDocElement = new OutParam((XMLElement)nodeList.item(n), this.processor);
            this.addOutParam((OutParam)pipeDocElement);
        }
        this.listenerList = new Vector();
        this.initialize();
    }

    protected void initialize() {
    }

    final String getId() {
        return this.id;
    }

    final String getType() {
        return this.type;
    }

    final Boolean getIgnoreErrors() {
        return this.ignoreErrors;
    }

    public final Enumeration getInputs() {
        if (this.inputs == null) {
            return null;
        }
        return this.inputs.elements();
    }

    final void addInput(Input input) {
        this.inputs.put(input.getName(), input);
    }

    public final Input getInput(String string) {
        return (Input)this.inputs.get(string);
    }

    public final Enumeration getOutputs() {
        if (this.outputs == null) {
            return null;
        }
        return this.outputs.elements();
    }

    final void addOutput(Output output) {
        this.outputs.put(output.getName(), output);
    }

    public Output getOutput(String string) {
        return (Output)this.outputs.get(string);
    }

    public final Enumeration getErrors() {
        if (this.errors == null) {
            return null;
        }
        return this.errors.elements();
    }

    public final Error getError(String string) {
        return (Error)this.errors.get(string);
    }

    final void addError(Error error) {
        this.errors.put(error.getName(), error);
    }

    public final Enumeration getInParams() {
        if (this.inParams == null) {
            return null;
        }
        return this.inParams.elements();
    }

    public final Object getInParamValue(String string) {
        if (this.inParams == null) {
            return null;
        }
        InParam inParam = (InParam)this.inParams.get(string);
        if (inParam == null) {
            return null;
        }
        return inParam.getValue();
    }

    final void addInParam(InParam inParam) {
        this.inParams.put(inParam.getName(), inParam);
    }

    public final Enumeration getOutParams() {
        if (this.outParams != null) {
            return this.outParams.elements();
        }
        return null;
    }

    public final Object getOutParamValue(String string) {
        if (this.outParams == null) {
            return null;
        }
        OutParam outParam = (OutParam)this.outParams.get(string);
        if (outParam == null) {
            return null;
        }
        return outParam.getValue();
    }

    final void addOutParam(OutParam outParam) {
        this.outParams.put(outParam.getName(), outParam);
    }

    synchronized void dispatchProcessDoneEvent(ProcessDoneEvent processDoneEvent) throws PipelineException {
        Enumeration enumeration = this.getListeners();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            Process process = (Process)((ProcessListener)enumeration.nextElement());
            if (!process.processDone(processDoneEvent)) continue;
            this.removeProcessListener(process);
        }
        this.setProcessStatus((short)1);
    }

    @Override
    public void run() {
        block13: {
            block14: {
                while (true) {
                    this.setProcessStatus((short)0);
                    try {
                        this.execute();
                    }
                    catch (PipelineException pipelineException) {
                        this.setProcessStatus((short)3);
                        try {
                            this.cleanup();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                    if (this.getProcessStatus() != 2) break block14;
                    if (!this.multiThreaded) break;
                    Thread.yield();
                }
                try {
                    this.processor.putProcessOnQueue(this);
                }
                catch (PipelineException pipelineException) {
                    this.setProcessStatus((short)3);
                    try {
                        this.cleanup();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            try {
                this.cleanup();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.dispatchProcessDoneEvent(new ProcessDoneEvent(this));
            }
            catch (PipelineException pipelineException) {}
        }
    }

    protected void execute() throws PipelineException {
    }

    private void cleanup() throws IOException {
        PipeDocElement pipeDocElement;
        Enumeration enumeration = this.getInputs();
        while (enumeration != null && enumeration.hasMoreElements()) {
            pipeDocElement = (Input)enumeration.nextElement();
            ((Input)pipeDocElement).cleanup();
        }
        enumeration = this.getOutputs();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            pipeDocElement = (Output)enumeration.nextElement();
            ((Output)pipeDocElement).cleanup();
        }
    }

    public final Source getInputSource(String string) {
        Input input = (Input)this.inputs.get(string);
        if (input == null) {
            return null;
        }
        return input.getSource();
    }

    public final void setOutputResult(String string, Result result) {
        Output output = (Output)this.outputs.get(string);
        output.setResult(result);
    }

    public final void setOutParam(String string, Object object) {
        OutParam outParam = (OutParam)this.outParams.get(string);
        outParam.setValue(object);
    }

    public final OutputStream getOutputStream(String string) throws FileNotFoundException, IOException {
        Output output = (Output)this.outputs.get(string);
        return output.createStream();
    }

    public final Writer getOutputWriter(String string) throws FileNotFoundException, IOException {
        Output output = (Output)this.outputs.get(string);
        return output.createWriter();
    }

    boolean inputsAvailable() {
        Enumeration enumeration = this.getInputs();
        while (enumeration.hasMoreElements()) {
            if (((Input)enumeration.nextElement()).isAvailable()) continue;
            return false;
        }
        if (this.inParams != null) {
            enumeration = this.getInParams();
            while (enumeration.hasMoreElements()) {
                if (((InParam)enumeration.nextElement()).isAvailable()) continue;
                return false;
            }
        }
        return true;
    }

    private void addProcessListener(ProcessListener processListener) {
        if (!this.listenerList.contains(processListener)) {
            this.listenerList.add(processListener);
        }
    }

    private void removeProcessListener(ProcessListener processListener) {
        this.listenerList.remove(processListener);
    }

    Enumeration getListeners() {
        if (this.listenerList == null) {
            return null;
        }
        return this.listenerList.elements();
    }

    @Override
    public final boolean processDone(ProcessDoneEvent processDoneEvent) throws PipelineException {
        PipeDocElement pipeDocElement;
        Enumeration enumeration;
        PipeDocElement pipeDocElement2;
        Enumeration enumeration2 = processDoneEvent.getOutputs();
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            pipeDocElement2 = (Output)enumeration2.nextElement();
            enumeration = this.getInputs();
            while (enumeration != null && enumeration.hasMoreElements()) {
                pipeDocElement = (Input)enumeration.nextElement();
                if (pipeDocElement.getLabel().compareTo(pipeDocElement2.getLabel()) != 0) continue;
                try {
                    if (!((Input)pipeDocElement).isSAXBufferingDone()) {
                        return false;
                    }
                    this.pipeOutput2Input((Output)pipeDocElement2, (Input)pipeDocElement);
                }
                catch (IOException iOException) {
                    this.pipeError.error(30009, 17, (Exception)iOException);
                }
            }
        }
        enumeration2 = processDoneEvent.getOutParams();
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            pipeDocElement2 = (OutParam)enumeration2.nextElement();
            enumeration = this.getInParams();
            while (enumeration != null && enumeration.hasMoreElements()) {
                pipeDocElement = (InParam)enumeration.nextElement();
                if (pipeDocElement.getLabel().compareTo(pipeDocElement2.getLabel()) != 0) continue;
                this.pipeOutParam2InParam((OutParam)pipeDocElement2, (InParam)pipeDocElement);
            }
        }
        if (this.inputsAvailable()) {
            this.processor.putProcessOnQueue(this);
        }
        return true;
    }

    private void pipeOutput2Input(Output output, Input input) throws IOException {
        Result result = output.getResult();
        if (result instanceof DOMResult) {
            DOMSource dOMSource = new DOMSource(((DOMResult)result).getNode(), ((DOMResult)result).getSystemId());
            input.setSource(dOMSource);
            input.setAvailStatus(1);
        } else if (result instanceof StreamResult) {
            input.connectToURL();
        } else {
            if (input.getSource() == null) {
                SAXSource sAXSource = new SAXSource();
                input.setSource(sAXSource);
                input.setAvailStatus(1);
            }
            if (this.multiThreaded && !input.isAvailable()) {
                input.setAvailStatus(0);
            } else {
                input.setAvailStatus(1);
            }
        }
    }

    private void pipeOutParam2InParam(OutParam outParam, InParam inParam) {
        Object object = outParam.getValue();
        inParam.setValue(object);
        inParam.setAvailStatus(1);
    }

    private XMLElement locateDepProcess(String string, String string2, String string3) {
        boolean bl = false;
        XMLElement xMLElement = null;
        NodeList nodeList = this.pipeDoc.getDocument().getElementsByTagName("process");
        block0: for (int i = 0; i < nodeList.getLength() && !bl; ++i) {
            xMLElement = (XMLElement)nodeList.item(i);
            if (!xMLElement.hasChildNodes()) continue;
            NodeList nodeList2 = xMLElement.getChildrenByTagName(string2);
            for (int j = 0; j < nodeList2.getLength() && !bl; ++j) {
                XMLElement xMLElement2 = (XMLElement)nodeList2.item(j);
                String string4 = xMLElement2.getAttribute(string3);
                if (string4.compareTo(string) != 0) continue;
                xMLElement = (XMLElement)xMLElement2.getParentNode();
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            return null;
        }
        return xMLElement;
    }

    void setDependents() throws PipelineException, MalformedURLException {
        PipeDocElement pipeDocElement;
        Enumeration enumeration;
        Process process;
        String string;
        String string2;
        XMLElement xMLElement;
        PipeDocElement pipeDocElement2;
        if (this.prevProcessList != null) {
            return;
        }
        Enumeration enumeration2 = this.getInputs();
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            pipeDocElement2 = (Input)enumeration2.nextElement();
            if (((Input)pipeDocElement2).isAvailable()) continue;
            xMLElement = this.locateDepProcess(pipeDocElement2.getLabel(), "output", "label");
            if (xMLElement == null) {
                this.error(30014, 17, new String[]{pipeDocElement2.getLabel()});
            }
            if ((string2 = this.processor.getProcDef(xMLElement)) == null) {
                this.pipeError.setProcessId(xMLElement.getAttribute("id"));
                this.error(30010, 17, new String[]{xMLElement.getAttribute("type")});
            }
            string = xMLElement.getAttribute("id");
            process = null;
            process = (Process)this.processor.processList.get(string);
            if (process == null) {
                process = this.processor.createProcess(string2, string);
                process.init(xMLElement, this.processor, this.pipeError);
                this.processor.processList.put(string, process);
            }
            process.addProcessListener(this);
            this.setPrevProcess(string);
            enumeration = process.getOutputs();
            while (enumeration != null && enumeration.hasMoreElements()) {
                pipeDocElement = (Output)enumeration.nextElement();
                if (pipeDocElement2.getLabel().compareTo(pipeDocElement.getLabel()) != 0) continue;
                ((Output)pipeDocElement).setNextProcess(this);
                this.determineInputType((Input)pipeDocElement2, (Output)pipeDocElement);
                break;
            }
            ((Input)pipeDocElement2).setPrevProcess(process);
        }
        enumeration2 = this.getInParams();
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            pipeDocElement2 = (InParam)enumeration2.nextElement();
            if (((InParam)pipeDocElement2).isAvailable() || pipeDocElement2.getLabel() == null) continue;
            xMLElement = this.locateDepProcess(pipeDocElement2.getLabel(), "outparam", "label");
            if (xMLElement == null) {
                this.error(30014, 17, new String[]{pipeDocElement2.getLabel()});
            }
            if ((string2 = this.processor.getProcDef(xMLElement)) == null) {
                this.pipeError.setProcessId(xMLElement.getAttribute("id"));
                this.error(30010, 17, new String[]{xMLElement.getAttribute("type")});
            }
            string = xMLElement.getAttribute("id");
            process = null;
            process = (Process)this.processor.processList.get(string);
            if (process == null) {
                process = this.processor.createProcess(string2, string);
                process.init(xMLElement, this.processor, this.pipeError);
                this.processor.processList.put(string, process);
            }
            process.addProcessListener(this);
            this.setPrevProcess(string);
            enumeration = process.getOutParams();
            while (enumeration != null && enumeration.hasMoreElements()) {
                pipeDocElement = (OutParam)enumeration.nextElement();
                if (pipeDocElement2.getLabel().compareTo(pipeDocElement.getLabel()) != 0) continue;
                ((OutParam)pipeDocElement).setNextProcess(this);
                break;
            }
            ((InParam)pipeDocElement2).setPrevProcess(process);
        }
    }

    private void determineInputType(Input input, Output output) throws PipelineException {
        if (output.supportsType(5) && input.supportsType(1)) {
            input.setXMLType(1);
            output.setXMLType(5);
        } else if (output.supportsType(4) && input.supportsType(0)) {
            input.setXMLType(0);
            output.setXMLType(4);
        } else if (output.supportsType(6) && input.supportsType(2)) {
            input.setXMLType(2);
            output.setXMLType(6);
        } else if (output.supportsType(7) && input.supportsType(3)) {
            input.setXMLType(3);
            output.setXMLType(7);
        } else if (input.supportsType(1)) {
            input.setXMLType(1);
        } else if (input.supportsType(0)) {
            input.setXMLType(0);
        } else if (input.supportsType(2)) {
            input.setXMLType(2);
        } else {
            input.setXMLType(3);
        }
        if (!(output.supportsType(8) && input.supportsType(8) || output.supportsType(9) && input.supportsType(9) || output.supportsType(10) && input.supportsType(10))) {
            this.compatible = false;
        }
    }

    final void determineOutputXMLType() throws PipelineException {
        Enumeration enumeration = this.getOutputs();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            Output output = (Output)enumeration.nextElement();
            if (output.getNextProcessCount() == 0) {
                if (output.supportsType(6)) {
                    output.setXMLType(6);
                } else if (output.supportsType(7)) {
                    output.setXMLType(7);
                } else if (output.supportsType(4)) {
                    output.setXMLType(4);
                } else {
                    this.error(30011, 17);
                }
            } else if (output.isXMLType(-1)) {
                if (output.supportsType(5)) {
                    output.setXMLType(5);
                } else if (output.supportsType(4)) {
                    output.setXMLType(4);
                } else if (output.supportsType(6)) {
                    output.setXMLType(6);
                } else {
                    output.setXMLType(7);
                }
            }
            if (output.isXMLType(8) || this.compatible) continue;
            this.error(30012, 17);
        }
    }

    private void setPrevProcess(String string) {
        if (this.prevProcessList != null) {
            Enumeration enumeration = this.prevProcessList.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string.equals(string2)) continue;
                return;
            }
        } else {
            this.prevProcessList = new Vector();
        }
        this.prevProcessList.add(string);
    }

    private Process getPrevProcess(String string) {
        if (this.prevProcessList != null) {
            Enumeration enumeration = this.prevProcessList.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string.equals(string2)) continue;
                return (Process)this.processor.processList.get(string2);
            }
        }
        return null;
    }

    final Enumeration getPrevProcesses() {
        if (this.prevProcessList != null) {
            return this.prevProcessList.elements();
        }
        return null;
    }

    private boolean proceedOnError(String string) {
        if (this.ignoreErrors.booleanValue()) {
            if (string == null) {
                return true;
            }
            if (this.getErrors() != null && this.getError(string) != null) {
                return true;
            }
        }
        return false;
    }

    public Source getErrorSource(String string) {
        Error error = (Error)this.errors.get(string);
        return error.getSource();
    }

    public void getErrorStream(String string, OutputStream outputStream, boolean bl) throws IOException {
        Source source = this.getErrorSource(string);
        if (source instanceof StreamSource) {
            InputStream inputStream = ((StreamSource)source).getInputStream();
            int n = -1;
            while ((n = inputStream.read()) > 0) {
                outputStream.write(n);
            }
        } else if (bl && source instanceof DOMSource) {
            this.convertDOMToStream((DOMSource)source, outputStream);
        }
    }

    public final InputStream getErrorStream(String string, boolean bl) throws IOException {
        InputStream inputStream = null;
        Source source = this.getErrorSource(string);
        if (source instanceof StreamSource) {
            inputStream = ((StreamSource)source).getInputStream();
        } else if (bl && source instanceof DOMSource) {
            FileOutputStream fileOutputStream = new FileOutputStream(".pipetmp");
            this.convertDOMToStream((DOMSource)source, fileOutputStream);
            fileOutputStream.close();
            inputStream = new FileInputStream(".pipetmp");
        }
        return inputStream;
    }

    public XMLDocument getErrorDocument(String string, boolean bl) throws SAXException, XMLParseException, IOException {
        Source source = this.getErrorSource(string);
        XMLDocument xMLDocument = null;
        if (source instanceof DOMSource) {
            xMLDocument = (XMLDocument)((DOMSource)source).getNode();
        } else if (bl && source instanceof StreamSource) {
            xMLDocument = (XMLDocument)this.convertStreamToDOM((StreamSource)source);
        }
        return xMLDocument;
    }

    private XMLNode convertStreamToDOM(StreamSource streamSource) throws SAXException, XMLParseException, IOException {
        DOMParser dOMParser = this.getDOMParser();
        Closeable closeable = streamSource.getInputStream();
        if (closeable != null) {
            dOMParser.parse((InputStream)closeable);
        } else {
            closeable = streamSource.getReader();
            if (closeable != null) {
                dOMParser.parse((Reader)closeable);
            }
        }
        return dOMParser.getDocument();
    }

    private void convertDOMToStream(DOMSource dOMSource, OutputStream outputStream) throws IOException {
        XMLNode xMLNode = (XMLNode)dOMSource.getNode();
        xMLNode.print(outputStream);
    }

    private void convertDOMToWriter(DOMSource dOMSource, Writer writer) throws IOException {
        XMLNode xMLNode = (XMLNode)dOMSource.getNode();
        PrintWriter printWriter = new PrintWriter(writer);
        xMLNode.print(printWriter);
    }

    void setMultiThreaded(boolean bl) {
        this.multiThreaded = bl;
    }

    boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void error(int n, int n2, Exception exception) throws PipelineException {
        this.pipeError.setProcess(this);
        this.pipeError.error(n, n2, exception);
    }

    public void error(int n, int n2) throws PipelineException {
        this.pipeError.setProcess(this);
        this.pipeError.error(n, n2);
    }

    public void error(int n, int n2, String[] stringArray) throws PipelineException {
        this.pipeError.setProcess(this);
        this.pipeError.error(n, n2, stringArray);
    }

    public final void error(int n, Exception exception) throws PipelineException {
        this.pipeError.setProcess(this);
        this.pipeError.error(30001, n, exception);
    }

    public void info(String string) {
        this.pipeError.setProcess(this);
        this.pipeError.info(string);
    }

    public final void info(int n, String[] stringArray) {
        this.pipeError.setProcess(this);
        this.pipeError.info(n, stringArray);
    }

    public boolean ignoreError(String string) {
        return string != null && this.proceedOnError(string);
    }

    public final ContentHandler getSAXContentHandler(Output output) throws PipelineException {
        ContentHandler contentHandler = null;
        int n = output.getNextProcessCount();
        if (n == 1 && !this.multiThreaded) {
            Input input = output.getMatchingInput(0);
            contentHandler = input.isXMLType(0) ? new DocumentBuilder() : (input.isXMLType(2) ? new DocumentBuilder() : output.getNextProcess(0).SAXContentHandler());
        } else {
            contentHandler = new XMLMultiHandler();
            for (int i = 0; i < n; ++i) {
                ContentHandler contentHandler2;
                Process process;
                Input input = output.getMatchingInput(i);
                if (input.isXMLType(0)) {
                    contentHandler = new DocumentBuilder();
                    continue;
                }
                if (input.isXMLType(2)) {
                    contentHandler = new DocumentBuilder();
                    continue;
                }
                if (this.multiThreaded) {
                    process = output.getNextProcess(i);
                    contentHandler2 = process.SAXContentHandler();
                    if (contentHandler2 == null) {
                        return null;
                    }
                    SAXHandler sAXHandler = new SAXHandler(contentHandler2, process, new ProcessDoneEvent(this), input);
                    input.setSAXHandler(sAXHandler);
                    ((XMLMultiHandler)contentHandler).addContentHandler(sAXHandler);
                    continue;
                }
                process = output.getNextProcess(i);
                contentHandler2 = process.SAXContentHandler();
                if (contentHandler2 == null) {
                    return null;
                }
                ((XMLMultiHandler)contentHandler).addContentHandler(contentHandler2);
            }
        }
        return contentHandler;
    }

    public final ErrorHandler getSAXErrorHandler(Output output) {
        ErrorHandler errorHandler = null;
        if (!this.multiThreaded) {
            errorHandler = this.SAXErrorHandler();
        } else {
            int n = output.getNextProcessCount();
            for (int i = 0; i < n; ++i) {
                Input input = output.getMatchingInput(i);
                if (input.isXMLType(0)) {
                    errorHandler = this.SAXErrorHandler();
                    continue;
                }
                if (input.isXMLType(2)) {
                    errorHandler = this.SAXErrorHandler();
                    continue;
                }
                SAXHandler sAXHandler = input.getSAXHandler();
                ErrorHandler errorHandler2 = this.SAXErrorHandler();
                sAXHandler.setErrorHandler(errorHandler2);
                errorHandler = sAXHandler;
            }
        }
        return errorHandler;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        try {
            this.error(30001, 16, sAXParseException);
        }
        catch (PipelineException pipelineException) {
            throw new SAXException(pipelineException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        try {
            this.error(30001, 17, sAXParseException);
        }
        catch (PipelineException pipelineException) {
            throw new SAXException(pipelineException);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        try {
            this.error(30001, 18, sAXParseException);
        }
        catch (PipelineException pipelineException) {
            throw new SAXException(pipelineException);
        }
    }

    protected ContentHandler SAXContentHandler() throws PipelineException {
        return new DefaultHandler();
    }

    protected ErrorHandler SAXErrorHandler() {
        return this;
    }

    public final void convertFromSAX(SAXResult sAXResult, Output output) throws FileNotFoundException, IOException {
        ContentHandler contentHandler = sAXResult.getHandler();
        int n = output.getNextProcessCount();
        if (n == 0) {
            OutputStream outputStream = this.getOutputStream(output.getName());
            this.setOutputResult(output.getName(), new StreamResult(outputStream));
            XMLDocument xMLDocument = ((DocumentBuilder)contentHandler).getDocument();
            xMLDocument.print(outputStream);
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Process process = output.getNextProcess(i);
            Input input = output.getMatchingInput(i);
            if (input.isXMLType(0)) {
                object = new DOMResult(((DocumentBuilder)contentHandler).getDocument());
                this.setOutputResult(output.getName(), (Result)object);
                continue;
            }
            if (!input.isXMLType(2)) continue;
            object = this.getOutputStream(output.getName());
            this.setOutputResult(output.getName(), new StreamResult((OutputStream)object));
            XMLDocument xMLDocument = ((DocumentBuilder)contentHandler).getDocument();
            xMLDocument.print((OutputStream)object);
        }
    }

    public final void convertFromDOM(DOMResult dOMResult, Output output) throws SAXException, IOException, PipelineException {
        Object object;
        XMLNode xMLNode = (XMLNode)dOMResult.getNode();
        try {
            if (!(xMLNode instanceof XMLDocument)) {
                XMLDocument xMLDocument = new XMLDocument();
                object = xMLDocument.importNode((Node)xMLNode, true);
                xMLDocument.appendChild((Node)object);
                xMLNode = xMLDocument;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        int n = output.getNextProcessCount();
        if (n == 0) {
            object = this.getOutputStream(output.getName());
            xMLNode.print((OutputStream)object);
            this.setOutputResult(output.getName(), new StreamResult((OutputStream)object));
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object2;
            Process process = output.getNextProcess(i);
            Input input = output.getMatchingInput(i);
            if (input.isXMLType(1)) {
                object2 = this.getSAXContentHandler(output);
                xMLNode.reportSAXEvents((ContentHandler)object2);
                this.setOutputResult(output.getName(), new SAXResult((ContentHandler)object2));
                continue;
            }
            if (!input.isXMLType(2)) continue;
            object2 = this.getOutputStream(output.getName());
            xMLNode.print((OutputStream)object2);
            this.setOutputResult(output.getName(), new StreamResult((OutputStream)object2));
        }
    }

    public final void convertFromStream(StreamResult streamResult, Output output) throws SAXException, IOException, PipelineException {
        URL uRL = Util.createURL(output.getLabel());
        InputStream inputStream = Util.createInStream(uRL);
        int n = output.getNextProcessCount();
        for (int i = 0; i < n; ++i) {
            XMLConstants xMLConstants;
            Process process = output.getNextProcess(i);
            Input input = output.getMatchingInput(i);
            if (input.isXMLType(1)) {
                xMLConstants = new SAXParser();
                ContentHandler contentHandler = this.getSAXContentHandler(output);
                ((SAXParser)xMLConstants).setContentHandler(contentHandler);
                ((XMLParser)xMLConstants).parse(inputStream);
                this.setOutputResult(output.getName(), new SAXResult(contentHandler));
                continue;
            }
            if (!input.isXMLType(0)) continue;
            xMLConstants = this.convertStreamToDOM(new StreamSource(inputStream));
            this.setOutputResult(output.getName(), new DOMResult((Node)((Object)xMLConstants)));
        }
    }

    private DOMParser getDOMParser() {
        if (this.domParser != null) {
            this.domParser.reset();
        } else {
            this.domParser = new DOMParser();
        }
        return this.domParser;
    }

    synchronized int getProcessStatus() {
        return this.processStatus;
    }

    public synchronized void setProcessStatus(short s) {
        this.processStatus = s;
    }

    PipelineProcessor getProcessor() {
        return this.processor;
    }

    boolean isRunnable() {
        return this.getProcessStatus() != 1 && this.inputsAvailable();
    }
}

