/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.transx.DLFWriter;
import oracle.xml.transx.TxuErrMsg;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Unloader {
    Connection con;
    String sql;
    String table;
    DLFWriter dw;

    Unloader(Connection connection) {
        this.con = connection;
    }

    void setQuery(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("select ");
        if (stringArray == null) {
            stringArray = new String[]{"*"};
        }
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" from ");
        stringBuffer.append(string);
        this.sql = stringBuffer.toString();
        this.table = string;
    }

    void unload() {
        if (this.sql == null) {
            String string = TxuErrMsg.getMessage(403, "UNLOAD_WITHOUT_SQL");
            throw new RuntimeException(string);
        }
        if (this.dw != null) {
            return;
        }
        OracleXMLQuery oracleXMLQuery = new OracleXMLQuery(this.con, this.sql);
        oracleXMLQuery.setDateFormat("yyyy'-'MM'-'dd'T'HH:mm:ss");
        Document[] documentArray = oracleXMLQuery.getXMLSchema();
        XMLDocument xMLDocument = (XMLDocument)documentArray[0];
        if (xMLDocument == null) {
            String string = TxuErrMsg.getMessage(403, "SCHEMA_NOT_OBTAINED");
            throw new RuntimeException(string);
        }
        this.dw = new DLFWriter(this.table);
        Vector vector = this.getLookupKeyColumns();
        this.dw.writeLookupKeys(vector);
        Properties properties = this.getColumnInfo(xMLDocument);
        this.dw.writeColumnList(properties);
        Document document = oracleXMLQuery.getXMLDOM(0);
        this.writeDataset(this.dw, (XMLDocument)document);
    }

    void writeDataset(DLFWriter dLFWriter, XMLDocument xMLDocument) {
        dLFWriter.startDataset();
        NodeList nodeList = null;
        try {
            nodeList = xMLDocument.selectNodes("/ROWSET/ROW");
        }
        catch (XSLException xSLException) {
            String string = TxuErrMsg.getMessage(404, xSLException.getMessage());
            throw new RuntimeException(string);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            dLFWriter.startRow();
            Node node = nodeList.item(i);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                String string = node2.getNodeName();
                String string2 = ((XMLNode)node2).getText();
                dLFWriter.column(string, string2);
            }
            dLFWriter.endRow();
        }
        dLFWriter.endDataset();
    }

    Properties getColumnInfo(XMLDocument xMLDocument) {
        NSResolver nSResolver = (NSResolver)((Object)xMLDocument.getFirstChild());
        String string = nSResolver.resolveNamespacePrefix("xsd");
        Properties properties = new Properties();
        String string2 = "/xsd:schema/xsd:element/xsd:complexType/xsd:sequence/xsd:element/xsd:complexType/xsd:sequence/xsd:element";
        NodeList nodeList = null;
        try {
            nodeList = xMLDocument.selectNodes(string2, nSResolver);
        }
        catch (XSLException xSLException) {
            String string3 = TxuErrMsg.getMessage(404, xSLException.getMessage());
            throw new RuntimeException(string3);
        }
        if (nodeList == null) {
            String string4 = TxuErrMsg.getMessage(401, string2);
            throw new RuntimeException(string4);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XMLElement xMLElement = (XMLElement)nodeList.item(i);
            String string5 = xMLElement.getAttribute("name");
            String string6 = xMLElement.getAttribute("type");
            if (string6.length() == 0 || string6 == null) {
                Node node;
                try {
                    node = xMLElement.selectSingleNode("xsd:simpleType/xsd:restriction", nSResolver);
                }
                catch (XSLException xSLException) {
                    String string7 = TxuErrMsg.getMessage(404, xSLException.getMessage());
                    throw new RuntimeException(string7);
                }
                string6 = ((XMLElement)node).getAttribute("base");
            }
            properties.put(string5, string6);
        }
        return properties;
    }

    Vector getLookupKeyColumns() throws RuntimeException {
        Vector<String> vector;
        String string = "select cc.column_name from all_constraints c, all_cons_columns cc where c.table_name = '" + this.table.toUpperCase() + "' and c.constraint_type = 'P' " + "and c.constraint_name = cc.constraint_name";
        try {
            Statement statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                return null;
            }
            vector = new Vector<String>();
            vector.addElement(resultSet.getString(1));
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            String string2 = TxuErrMsg.getMessage(307, sQLException.getMessage());
            throw new RuntimeException(string2);
        }
        return vector;
    }

    public String toString() {
        String string = this.dw.toString();
        return string;
    }

    Reader getReader() {
        Reader reader = this.dw.getReader();
        return reader;
    }

    void writeTo(Writer writer) {
        this.dw.writeTo(writer);
    }
}

